/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWParamExpressionCellEditor;
import filenet.vw.toolkit.utils.table.IVWSortItem;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VWCaseParameterInfo
implements IVWSortItem {
    private static String MODE_STRING_READ = VWResource.s_accessModeIndicator.toString(VWResource.s_read);
    private static String MODE_STRING_WRITE = VWResource.s_accessModeIndicator.toString(VWResource.s_write);
    private static String MODE_STRING_READ_WRITE = VWResource.s_accessModeIndicator.toString(VWResource.s_readWrite);
    private String m_propertyName = null;
    private int m_nType = -1;
    private boolean m_bIsArray = false;
    private int m_nMode = -1;
    private VWParameterDefinition m_parameterDef = null;

    VWCaseParameterInfo(String propertyName, int nType, boolean bIsArray) {
        this.m_propertyName = propertyName;
        this.m_nType = nType;
        this.m_bIsArray = bIsArray;
    }

    VWCaseParameterInfo(String propertyName, VWParameterDefinition parameterDef) {
        this.m_propertyName = propertyName;
        this.m_parameterDef = parameterDef;
        this.m_nMode = this.m_parameterDef.getMode();
    }

    public VWParameterDefinition getParameterDefinition() {
        return this.m_parameterDef;
    }

    public VWParameterDefinition createParameterDefinition(String fieldName, VWStepDefinition stepDefinition, VWAuthPropertyData authPropertyData) throws VWException {
        if (this.m_parameterDef == null) {
            String parameterName = this.m_propertyName;
            int nCount = 1;
            try {
                while (true) {
                    stepDefinition.getParameterDefinition(parameterName);
                    parameterName = this.m_propertyName + nCount++;
                }
            }
            catch (VWException ex) {
                String expression = fieldName + "." + this.m_propertyName;
                this.m_parameterDef = stepDefinition.createParameter(parameterName, this.m_nMode, expression, this.m_nType, this.m_bIsArray);
            }
        }
        return this.m_parameterDef;
    }

    public int getMode() {
        return this.m_nMode;
    }

    public void setMode(int newMode) throws VWException {
        if (this.m_parameterDef != null && VWModeType.isValid(newMode)) {
            this.m_parameterDef.setMode(newMode);
        }
        this.m_nMode = newMode;
    }

    public String toString() {
        String name = null;
        switch (this.getMode()) {
            case 1: {
                name = this.m_propertyName + MODE_STRING_READ;
                break;
            }
            case 2: {
                name = this.m_propertyName + MODE_STRING_WRITE;
                break;
            }
            case 3: {
                name = this.m_propertyName + MODE_STRING_READ_WRITE;
                break;
            }
            default: {
                name = this.m_propertyName;
            }
        }
        return name;
    }

    @Override
    public String getName() {
        return this.m_propertyName;
    }

    protected static VWCaseParameterInfo[] getSupportedProperties(VWFieldDefinition fieldDef) {
        CEObjectInfo ceObjInfo;
        ArrayList<VWCaseParameterInfo> propertyInfoList = new ArrayList<VWCaseParameterInfo>();
        if (fieldDef != null && (ceObjInfo = fieldDef.getCEObjectInfo()) != null) {
            try {
                Object[] propertyNames = ceObjInfo.getPropertyTypeNames();
                if (propertyNames != null) {
                    VWQubbleSort.sort(propertyNames);
                    for (int i = 0; i < propertyNames.length; ++i) {
                        try {
                            int nPropertyType = ceObjInfo.getPropertyType((String)propertyNames[i]);
                            if (!VWFieldType.isValid(nPropertyType)) continue;
                            boolean bIsArray = ceObjInfo.getPropertyIsArray((String)propertyNames[i]);
                            propertyInfoList.add(new VWCaseParameterInfo((String)propertyNames[i], nPropertyType, bIsArray));
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return propertyInfoList.toArray(new VWCaseParameterInfo[0]);
    }

    protected static HashMap<String, ArrayList<VWCaseParameterInfo>> getSelectedProperties(String[] guidFieldNames, VWParameterDefinition[] parameterDefs) {
        if (guidFieldNames == null || guidFieldNames.length == 0) {
            return null;
        }
        HashMap<String, ArrayList<VWCaseParameterInfo>> resultMap = new HashMap<String, ArrayList<VWCaseParameterInfo>>(guidFieldNames.length);
        try {
            int i;
            for (i = 0; i < guidFieldNames.length; ++i) {
                resultMap.put(guidFieldNames[i], new ArrayList());
            }
            if (parameterDefs != null) {
                block3: for (i = 0; i < parameterDefs.length; ++i) {
                    String expression = parameterDefs[i].getValue();
                    for (int j = 0; j < guidFieldNames.length; ++j) {
                        String propertyName;
                        String prefix = guidFieldNames[j] + ".";
                        if (!expression.startsWith(prefix) || !VWFieldType.isValidName(propertyName = expression.substring(prefix.length()))) continue;
                        ArrayList<VWCaseParameterInfo> paramList = resultMap.get(guidFieldNames[j]);
                        paramList.add(new VWCaseParameterInfo(propertyName, parameterDefs[i]));
                        continue block3;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return resultMap;
    }

    protected static String[] getGuidFieldNames(VWAuthPropertyData authPropertyData) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (authPropertyData.getField("F_CaseFolder") != null) {
            fieldNames.add("F_CaseFolder");
        }
        if (authPropertyData.getField("F_CaseTask") != null) {
            fieldNames.add("F_CaseTask");
        }
        String[] systemGuids = null;
        if (fieldNames.size() > 0) {
            systemGuids = fieldNames.toArray(new String[0]);
        }
        return systemGuids;
    }

    public static void removePostAssignments(VWParameterDefinition[] parameterDefs, VWStepDefinition stepDefinition) throws VWException {
        int i;
        if (parameterDefs == null || parameterDefs.length == 0) {
            return;
        }
        ArrayList<String[]> assignmentList = new ArrayList<String[]>();
        String[][] postAssignments = stepDefinition.getPostAssignments();
        if (postAssignments != null) {
            for (i = 0; i < postAssignments.length; ++i) {
                assignmentList.add(postAssignments[i]);
            }
        }
        for (i = 0; i < parameterDefs.length; ++i) {
            String symbolicName;
            int nIndex;
            String expression = parameterDefs[i].getValue();
            if (expression == null || !expression.startsWith("F_") || (nIndex = expression.indexOf(".")) == -1 || !VWFieldType.isValidName(symbolicName = expression.substring(nIndex + 1))) continue;
            for (int j = assignmentList.size() - 1; j >= 0; --j) {
                String[] assignmentItem = (String[])assignmentList.get(j);
                if (assignmentItem[1] == null || !assignmentItem[1].equals(expression)) continue;
                assignmentList.remove(j);
            }
        }
        postAssignments = null;
        if (assignmentList.size() > 0) {
            postAssignments = (String[][])assignmentList.toArray((T[])new String[0][0]);
        }
        stepDefinition.setPostAssignments(postAssignments);
    }

    protected static void updatePostAssignments(String fieldName, VWStepDefinition stepDefinition, VWAuthPropertyData authPropertyData, VWParameterDefinition[] parameterDefs) throws VWException {
        int i;
        if (parameterDefs == null || parameterDefs.length == 0) {
            return;
        }
        ArrayList<String[]> assignmentList = new ArrayList<String[]>();
        String[][] postAssignments = stepDefinition.getPostAssignments();
        if (postAssignments != null) {
            for (i = 0; i < postAssignments.length; ++i) {
                assignmentList.add(postAssignments[i]);
            }
        }
        for (i = 0; i < parameterDefs.length; ++i) {
            String prefix;
            String symbolicName = null;
            String expression = parameterDefs[i].getValue();
            if (expression.startsWith(prefix = fieldName + ".") && !VWFieldType.isValidName(symbolicName = expression.substring(prefix.length()))) continue;
            int nIndex = -1;
            for (int j = 0; j < assignmentList.size(); ++j) {
                String[] assignmentItem = (String[])assignmentList.get(j);
                if (!assignmentItem[0].equals(symbolicName) || !assignmentItem[1].equals(expression)) continue;
                nIndex = j;
                break;
            }
            if (parameterDefs[i].getMode() == 1) {
                if (nIndex == -1) continue;
                assignmentList.remove(nIndex);
                continue;
            }
            VWFieldDefinition fieldDef = authPropertyData.getField(symbolicName);
            if (fieldDef == null) {
                VWWorkflowDefinition wflDef = authPropertyData.getWorkflowDefinition();
                String newValue = VWParamExpressionCellEditor.getInitialFieldValue(parameterDefs[i].getDataType(), parameterDefs[i].getIsArray());
                wflDef.createFieldUsingString(symbolicName, newValue, parameterDefs[i].getDataType(), parameterDefs[i].getIsArray());
            } else if (fieldDef.getFieldType() != parameterDefs[i].getDataType() || fieldDef.isArray() != parameterDefs[i].getIsArray()) continue;
            if (nIndex != -1) continue;
            String[] newAssignment = new String[]{symbolicName, expression};
            assignmentList.add(newAssignment);
        }
        postAssignments = null;
        if (assignmentList.size() > 0) {
            postAssignments = (String[][])assignmentList.toArray((T[])new String[0][0]);
        }
        stepDefinition.setPostAssignments(postAssignments);
    }
}

